
.include "m32def.inc"


; redefinirea registrilor
 .def temp  = r16
 .def cntL  = r26
 .def cntH  = r27
 .def flags = r2
 .def iTmp = r17
  

.cseg	; segmentul de cod 
.org	0x0000
	rjmp	RESET	; Salt neconditionat

.org	INT0addr	; External Interrupt0 Vector Address
	rjmp INT0Sub

.org	INT1addr	; External Interrupt1 Vector Address
	reti

.org	INT2addr	; External Interrupt2 Vector Address
	reti
.org	OC2addr	    ; Output Compare2 Interrupt Vector Address
	reti 
.org	OVF2addr	; Overflow2 Interrupt Vector Address
	reti
.org	ICP1addr	; Input Capture1 Interrupt Vector Address
	reti
.org	OC1Aaddr	; Output Compare1A Interrupt Vector Address
	reti
.org	OC1Baddr	; Output Compare1B Interrupt Vector Address
	reti
.org	OVF1addr	; Overflow1 Interrupt Vector Address
	reti
.org	OC0addr	    ; Output Compare0 Interrupt Vector Address
	rjmp	TimeInterval
.org	OVF0addr	; Overflow0 Interrupt Vector Address
	reti
.org	SPIaddr	     ; SPI Interrupt Vector Address
	reti
.org	URXCaddr	; USART Receive Complete Interrupt Vector Address
	reti
.org	UDREaddr	; USART Data Register Empty Interrupt Vector Address
	reti
.org	UTXCaddr	; USART Transmit Complete Interrupt Vector Address
	reti
.org	ADCCaddr	; ADC Interrupt Vector Address
	reti
.org	ERDYaddr	; EEPROM Interrupt Vector Address
	reti
.org	ACIaddr 	; Analog Comparator Interrupt Vector Address
	reti
.org    TWIaddr   ; Irq. vector address for Two-Wire Interface
	reti
.org	SPMRaddr	; Store Program Memory Ready Interrupt Vector Address
	reti

//---------------------------------------------------------------
INT0Sub:    ;Subrutina de prelucrare a intreruperii
 		; comenzi pentru subruta data
		in flags, SREG
		sbis	PIND, PD2
		rjmp NegEdje
		ldi temp,(1<<COM01)|(1<<WGM01)|(1<<WGM00)|(0<<CS02)|(1<<CS01)|(0<<CS00) ;alegem prescalerul 1 la 8
		out TCCR0, temp 
		out SREG, flags
		reti
NegEdje:
		ldi temp,(1<<COM01)|(1<<WGM01)|(1<<WGM00)|(0<<CS02)|(0<<CS01)|(0<<CS00) ;oprim timerul
		out TCCR0, temp 
		out SREG, flags
		reti


 //---------------------------------------------------------------
TimeInterval: 
		; comenzi pentru subruta data
		in flags, SREG
		
		in itmp, OCR0
		inc itmp
		out OCR0, itmp

		ADIW cntL,1
		out PORTC, cntL
		out PORTB, cntH

		out SREG, flags
	    reti

; Programul principal
//--------------------------------------------------------------	 
RESET:	 
     ldi temp, Low(RAMEND) 	; initializam stiva
	 out SPL, temp
	 ldi temp, High(RAMEND) 
	 out SPH, temp
 
	 CLR temp				;resetam temp
	 		; Setam ca intrare PORTA 	
	 out DDRD, temp			; Setam ca intrare PORTD


	 SER temp
	 out DDRA, temp
	 out DDRB, temp		; Setam ca iesire PORTB
	 out DDRC, temp			; Setam ca iesire PORTC

	 

	ldi temp, (0<<ISC01)|(1<<ISC00)
	out MCUCR, temp
	ldi temp, (1<<INT0)		; validam intreruperea INT0
	out GICR, temp


	CLR cntL
	CLR cntH
	SEI
	
	ldi temp, 194
	out OCR0, temp
	ldi temp,(1<<COM01)|(1<<WGM01)|(1<<WGM00)|(1<<CS02)|(1<<CS01)|(0<<CS00) ;alegem Fast PWM, prescalerul 1 la 1024
	out TCCR0, temp 

	ldi temp,(1<<OCIE0); permitem intreruperea la timerul compare
	out TIMSK, temp 

 MAIN: ; programul principal
 nop
 rjmp main
   
