
.include "m32def.inc"


; redefinirea registrilor
 .def flags = r2 
 .def temp  = r16
 .def cnt  =r18
 .def Itmp = r17
 .def cnt24 = r26
 .def cntH = r27 

.cseg	; segmentul de cod 
.org	0x0000
	rjmp	RESET	; Salt neconditionat

.org	INT0addr	; External Interrupt0 Vector Address
	reti

.org	INT1addr	; External Interrupt1 Vector Address
	reti

.org	INT2addr	; External Interrupt2 Vector Address
	reti
.org	OC2addr	    ; Output Compare2 Interrupt Vector Address
	reti 
.org	OVF2addr	; Overflow2 Interrupt Vector Address
	reti
.org	ICP1addr	; Input Capture1 Interrupt Vector Address
	rjmp Capture


.org	OC1Aaddr	; Output Compare1A Interrupt Vector Address
	reti
.org	OC1Baddr	; Output Compare1B Interrupt Vector Address
	reti
.org	OVF1addr	; Overflow1 Interrupt Vector Address
	rjmp TimerOverflowSub
.org	OC0addr	    ; Output Compare0 Interrupt Vector Address
	reti
.org	OVF0addr	; Overflow0 Interrupt Vector Address
	reti
.org	SPIaddr	     ; SPI Interrupt Vector Address
	reti
.org	URXCaddr	; USART Receive Complete Interrupt Vector Address
	reti
.org	UDREaddr	; USART Data Register Empty Interrupt Vector Address
	reti
.org	UTXCaddr	; USART Transmit Complete Interrupt Vector Address
	reti
.org	ADCCaddr	; ADC Interrupt Vector Address
	reti
.org	ERDYaddr	; EEPROM Interrupt Vector Address
	reti
.org	ACIaddr 	; Analog Comparator Interrupt Vector Address
	reti
.org    TWIaddr   ; Irq. vector address for Two-Wire Interface
	reti
.org	SPMRaddr	; Store Program Memory Ready Interrupt Vector Address
	reti

//---------------------------------------------------------------
Capture:    ;Subrutina de prelucrare a intreruperii
 		; comenzi pentru subruta data
		in flags, SREG

		clr itmp
		out TCNT1H, itmp	; resetem contoru
		out TCNT1L, itmp

		in itmp, ICR1L		; afisem valoarea contorului
		out PORTC, itmp
		in itmp, ICR1H
		out PORTA, itmp
		out PORTB, cnt24
		clr cnt24
		out SREG, flags
	 reti
	 //---------------------------------------------------------------
TimerOverflowSub: 
		; comenzi pentru subruta data
		in flags, SREG
		inc cnt24
		out SREG, flags
	    reti

; Programul principal
//--------------------------------------------------------------	 
RESET:	 
     ldi temp, Low(RAMEND) 	; initializam stiva
	 out SPL, temp
	 ldi temp, High(RAMEND) 
	 out SPH, temp
 
	 CLR temp				;resetam temp
	 		; Setam ca intrare PORTA 	
	 out DDRD, temp			; Setam ca intrare PORTD


	 SER temp
	 out DDRC, temp		; Setam ca iesire PORTC
	 out DDRB, temp		; Setam ca iesire PORTB

	 ldi temp, 0x7f
	 out DDRA, temp



	 clr cnt24


	ldi temp, (1<<ACBG)|(1<<ACIC)|(1<<ACIS1)
	out ACSR, temp

	ldi temp, (1<<ACME)
	out SFIOR, temp
	ldi temp, (1<<MUX2)|(1<<MUX1)|(1<<MUX0)
	out ADMUX, temp

	ldi temp, 0
	out TCCR1A, temp
	ldi temp,(1<<ICES1)|(0<<CS02)|(0<<CS01)|(1<<CS00) ;Normal Operation, Pozitive Edge ICP prescalerul 1 la 1
	out TCCR1B, temp 

	ldi temp,(1<<ICF1); resetam flagul de intrerupere (care posibil s-a produs mai inainte)
	out TIFR, temp 

	ldi temp,(1<<TICIE1)|(1<<TOIE1); permitem intreruperea Input Capture
	out TIMSK, temp 
	SEI


 MAIN: ; programul principal
	

	ldi temp, 255
  delay_ext:
    ldi cnt, 10
	delay_int:
		dec cnt
		brne delay_int
	dec temp
	brne delay_ext

 rjmp main
   
