
.include "m32def.inc"

.equ CompareVal = 200	; Valoarea de comparare in registrul OCR0 pentru Timer0


; redefinirea registrilor
 .def flags = r2 
 .def temp  = r16
 .def cnt  =r18
 .def Itmp = r17
 .def cntL = r26
 .def cntH = r27 

.cseg	; segmentul de cod 
.org	0x0000
	rjmp	RESET	; Salt neconditionat

.org	INT0addr	; External Interrupt0 Vector Address
	reti

.org	INT1addr	; External Interrupt1 Vector Address
	reti

.org	INT2addr	; External Interrupt2 Vector Address
	reti
.org	OC2addr	    ; Output Compare2 Interrupt Vector Address
	reti 
.org	OVF2addr	; Overflow2 Interrupt Vector Address
	reti
.org	ICP1addr	; Input Capture1 Interrupt Vector Address
	reti
.org	OC1Aaddr	; Output Compare1A Interrupt Vector Address
	rjmp OC1A_ISR
.org	OC1Baddr	; Output Compare1B Interrupt Vector Address
	reti
.org	OVF1addr	; Overflow1 Interrupt Vector Address
		reti
.org	OC0addr	    ; Output Compare0 Interrupt Vector Address
	rjmp CompareSub
.org	OVF0addr	; Overflow0 Interrupt Vector Address
	reti
.org	SPIaddr	     ; SPI Interrupt Vector Address
	reti
.org	URXCaddr	; USART Receive Complete Interrupt Vector Address
	reti
.org	UDREaddr	; USART Data Register Empty Interrupt Vector Address
	reti
.org	UTXCaddr	; USART Transmit Complete Interrupt Vector Address
	reti
.org	ADCCaddr	; ADC Interrupt Vector Address
	reti
.org	ERDYaddr	; EEPROM Interrupt Vector Address
	reti
.org	ACIaddr 	; Analog Comparator Interrupt Vector Address
	reti
.org    TWIaddr   ; Irq. vector address for Two-Wire Interface
	reti
.org	SPMRaddr	; Store Program Memory Ready Interrupt Vector Address
	reti

OC1A_ISR:
		in flags, SREG

		out SREG, flags
	 reti


//---------------------------------------------------------------
CompareSub:    ;Subrutina de prelucrare a intreruperii
 		; comenzi pentru subruta data
		in flags, SREG
/*		
		ADIW cntL,1
		out PORTA, cntL
 	    out PORTB, cntH
*/
		out SREG, flags
	 reti

; Programul principal
//--------------------------------------------------------------	 
RESET:	 
     ldi temp, Low(RAMEND) 	; initializam stiva
	 out SPL, temp
	 ldi temp, High(RAMEND) 
	 out SPH, temp
 
	 CLR temp				;resetam temp
	 		; Setam ca intrare PORTA 	
	 out DDRD, temp			; Setam ca intrare PORTD


	 SER temp
	 out DDRA, temp

	 out PORTC, temp		; Setam ca input cu PullUp
	 out PORTD, temp

	 ldi temp, 1<<PB3
	 out DDRB, temp		; Setam ca iesire PORTB

	 clr cntL
	 clr cntH
/*
	ldi temp, High(CompareVal)
	out OCR1AH, temp
	ldi temp, Low(CompareVal)
	out OCR1AL, temp

	ldi temp, 0x00
	out TCCR1A, temp 
	ldi temp, (1<< WGM12)|(0<<CS12)|(1<<CS11)|(0<<CS10) ;alegem prescalerul 1/8
	out TCCR1B, temp 


	ldi temp,(1<<OCIE1A); permitem intreruperea la Overflow
	out TIMSK, temp 
*/

	ldi temp, CompareVal
	out OCR0, temp
	ldi temp, (1<<WGM01)|(0<<WGM00)|(0<<COM01)|(1<<COM00)|(0<<CS02)|(1<<CS01)|(1<<CS00) ;alegem prescalerul 1/64
	out TCCR0, temp 

	ldi temp,(0<<OCIE0); permitem intreruperea la compare match
	out TIMSK, temp 
	sei


	ldi ZL, low(table<<1)
	ldi ZH, High(table<<1)
 MAIN: ; programul principal
	nop
	nop
	nop
	ldi ZH, high(table*2)
	ldi ZL, Low(table*2)
loop:
	lpm temp, Z+
	andi ZL, 0x1F
	out OCR0, temp
	

	rcall Delay
	rcall Delay
	rcall Delay
	rjmp loop
 rjmp main



/////////////////////////////////
Delay:
	push cnt
	ldi cnt, 200
 ext_loop:
	push cnt
	ldi cnt, 250
 	cnt_loop:
 		nop
		nop
		nop
		nop
		nop
		nop
		nop
		dec cnt
	brne cnt_loop		
	pop cnt
 dec cnt
 brne ext_loop
 	pop cnt
	ret

 ;tabelul cu valori 
.org 0x0f00
table: 
	.db 0, 5, 10, 20, 30, 60, 70, 80
	.db 90, 91, 124, 150, 180, 200, 230, 245
	.db 245, 230, 200, 180, 164, 122, 100, 90
	.db 80, 70, 54, 38, 24, 10, 5, 0
var2:
    .db  100, 200  

string1:
    .db "Hello World"



   
