
.include "m32def.inc"

.equ time_const = 256-78

; redefinirea registrilor
 .def flags = r2 
 .def temp  = r16
 .def cnt  =r18

.cseg	; segmentul de cod 
.org	0x0000
	rjmp	RESET	; Salt neconditionat

.org	INT0addr	; External Interrupt0 Vector Address
	reti

.org	INT1addr	; External Interrupt1 Vector Address
	reti

.org	INT2addr	; External Interrupt2 Vector Address
	reti
.org	OC2addr	    ; Output Compare2 Interrupt Vector Address
	reti 
.org	OVF2addr	; Overflow2 Interrupt Vector Address
	reti
.org	ICP1addr	; Input Capture1 Interrupt Vector Address
	reti
.org	OC1Aaddr	; Output Compare1A Interrupt Vector Address
	reti
.org	OC1Baddr	; Output Compare1B Interrupt Vector Address
	reti
.org	OVF1addr	; Overflow1 Interrupt Vector Address
	reti
.org	OC0addr	    ; Output Compare0 Interrupt Vector Address
	reti

.org	OVF0addr	; Overflow0 Interrupt Vector Address
	rjmp TimerOverflowSub

.org	SPIaddr	     ; SPI Interrupt Vector Address
	reti
.org	URXCaddr	; USART Receive Complete Interrupt Vector Address
	reti
.org	UDREaddr	; USART Data Register Empty Interrupt Vector Address
	reti
.org	UTXCaddr	; USART Transmit Complete Interrupt Vector Address
	reti
.org	ADCCaddr	; ADC Interrupt Vector Address
	reti
.org	ERDYaddr	; EEPROM Interrupt Vector Address
	reti
.org	ACIaddr 	; Analog Comparator Interrupt Vector Address
	reti
.org    TWIaddr   ; Irq. vector address for Two-Wire Interface
	reti
.org	SPMRaddr	; Store Program Memory Ready Interrupt Vector Address
	reti

//--------------------------------------------------------------	 
TimerOverflowSub: 
		; comenzi pentru subruta data
		in flags, SREG
		
		ldi temp, time_const
	 	out TCNT0, temp

		inc cnt
		out PORTB, cnt


		out SREG, flags
	    reti

; Programul principal
//--------------------------------------------------------------	 
RESET:	 
     ldi temp, Low(RAMEND) 	; initializam stiva
	 out SPL, temp
	 ldi temp, High(RAMEND) 
	 out SPH, temp
 
	 CLR temp				;resetam temp
	 		; Setam ca intrare PORTA 	
	 out DDRD, temp			; Setam ca intrare PORTD
	 out DDRA, temp
	 out DDRC, temp

	 SER temp	 
	 out DDRB, temp		; Setam ca iesire PORTB
	 
	 ldi temp, time_const
	 out TCNT0, temp


	ldi temp,(1<<CS02)|(0<<CS01)|(1<<CS00) ;alegem prescalerul 1 la 1024
	out TCCR0, temp 

	ldi temp,(1<<TOIE0); permitem intreruperea la Compare match
	out TIMSK, temp 
	sei



 MAIN: ; programul principal
   	nop
	nop
	nop
	nop
	
   	nop
	nop
	nop
	nop
 rjmp main
   
