
.include "m32def.inc"

.equ CompareVal = 99	; Valoarea de comparare in registrul OCR0 pentru Timer0


; redefinirea registrilor
 .def flags = r2 
 .def temp  = r16
 .def cnt  =r18
 .def Itmp = r17
 .def cntL = r28
 .def cntH = r29



.cseg	; segmentul de cod 
.org	0x0000
	rjmp	RESET	; Salt neconditionat

.org	INT0addr	; External Interrupt0 Vector Address
	reti

.org	INT1addr	; External Interrupt1 Vector Address
	reti

.org	INT2addr	; External Interrupt2 Vector Address
	reti
.org	OC2addr	    ; Output Compare2 Interrupt Vector Address
	reti 
.org	OVF2addr	; Overflow2 Interrupt Vector Address
	reti
.org	ICP1addr	; Input Capture1 Interrupt Vector Address
	reti
.org	OC1Aaddr	; Output Compare1A Interrupt Vector Address
	reti
.org	OC1Baddr	; Output Compare1B Interrupt Vector Address
	reti
.org	OVF1addr	; Overflow1 Interrupt Vector Address
	reti
.org	OC0addr	    ; Output Compare0 Interrupt Vector Address
	rjmp CompareSub
.org	OVF0addr	; Overflow0 Interrupt Vector Address
	reti
.org	SPIaddr	     ; SPI Interrupt Vector Address
	reti
.org	URXCaddr	; USART Receive Complete Interrupt Vector Address
	reti
.org	UDREaddr	; USART Data Register Empty Interrupt Vector Address
	reti
.org	UTXCaddr	; USART Transmit Complete Interrupt Vector Address
	reti
.org	ADCCaddr	; ADC Interrupt Vector Address
	reti
.org	ERDYaddr	; EEPROM Interrupt Vector Address
	reti
.org	ACIaddr 	; Analog Comparator Interrupt Vector Address
	reti
.org    TWIaddr   ; Irq. vector address for Two-Wire Interface
	reti
.org	SPMRaddr	; Store Program Memory Ready Interrupt Vector Address
	reti

//---------------------------------------------------------------
CompareSub:    ;Subrutina de prelucrare a intreruperii
 		; comenzi pentru subruta data
		in flags, SREG
		
		ADIW cntL,1
		out PORTA, cntL
 	    out PORTB, cntH

		out SREG, flags
	 reti

; Programul principal
//--------------------------------------------------------------	 
RESET:	 
     ldi temp, Low(RAMEND) 	; initializam stiva
	 out SPL, temp
	 ldi temp, High(RAMEND) 
	 out SPH, temp
 
	 CLR temp				;resetam temp
	 		; Setam ca intrare PORTA 	
	 out DDRD, temp			; Setam ca intrare PORTD


	 SER temp
	 out DDRA, temp
	 out DDRB, temp		; Setam ca iesire PORTC


	 out PORTC, temp		; Setam ca input cu PullUp
	 out PORTD, temp

	 clr cntL
	 clr cntH

	ldi temp, CompareVal
	out OCR0, temp
	ldi temp,(1<<WGM01)|(1<<WGM00)|(1<<COM01)|(0<<COM00)|(0<<CS02)|(1<<CS01)|(0<<CS00) ;alegem prescalerul 1/64
	out TCCR0, temp 

	ldi temp,(1<<OCIE0); permitem intreruperea la compare match
	out TIMSK, temp 
	sei
	ldi ZL, LOW(Table*2)
	ldi ZH, High(Table*2)
	ldi cnt, 31

 MAIN: ; programul principal
	rcall Delay
//	rcall Delay
	
	lpm	temp, Z+
	out OCR0, temp
	dec cnt
	brne Main

	ldi ZL, LOW(Table*2)
	ldi ZH, High(Table*2)
	ldi cnt, 32
 rjmp main
   
Delay:
	push cnt
	push temp
	ldi temp, 50
  loopExt:
  	ldi cnt, 255
  loopInt:
  	nop
	nop
  	dec cnt
	brne loopInt
	dec temp
	brne loopExt

	pop temp
	pop cnt
	ret


Table:
.DB 128, 153, 177, 199, 219, 234, 246, 254
.DB 255, 254, 246, 234, 219, 199, 177, 153
.DB 128, 103, 79,  57,  37,  22,  10,  2
.DB 0,   2,   10,  22,  37,  57,  79,  103
